// Main JavaScript for Portfolio Website

document.addEventListener('DOMContentLoaded', function() {
    // Smooth scroll for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });

    // Form validation
    const forms = document.querySelectorAll('.needs-validation');
    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });

    // Auto-hide alerts
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert');
        alerts.forEach(alert => {
            const bsAlert = new bootstrap.Alert(alert);
            bsAlert.close();
        });
    }, 5000);
});

// Enhanced functionality for certificates and pagination

// Image lazy loading for better performance
document.addEventListener('DOMContentLoaded', function() {
    // Lazy loading for certificate images
    const images = document.querySelectorAll('.certificate-img, .certificate-img-home');
    
    const imageObserver = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const img = entry.target;
                if (img.dataset.src) {
                    img.src = img.dataset.src;
                    img.classList.remove('lazy');
                    imageObserver.unobserve(img);
                }
            }
        });
    });

    images.forEach(img => {
        if (img.dataset.src) {
            imageObserver.observe(img);
        }
    });

    // Enhanced certificate card interactions
    const certificateCards = document.querySelectorAll('.certificate-card, .certificate-card-home');
    
    certificateCards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-10px) scale(1.02)';
        });
        
        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0) scale(1)';
        });
    });

    // Pagination keyboard navigation
    document.addEventListener('keydown', function(e) {
        const currentPage = parseInt(document.querySelector('.pagination .page-item.active .page-link')?.textContent);
        
        if (e.ctrlKey || e.metaKey) {
            switch(e.key) {
                case 'ArrowLeft':
                    e.preventDefault();
                    const prevLink = document.querySelector('.pagination .page-link[title="Halaman Sebelumnya"]');
                    if (prevLink) prevLink.click();
                    break;
                case 'ArrowRight':
                    e.preventDefault();
                    const nextLink = document.querySelector('.pagination .page-link[title="Halaman Selanjutnya"]');
                    if (nextLink) nextLink.click();
                    break;
            }
        }
    });

    // Search form enhancements
    const searchForm = document.querySelector('form[action*="certificates"]');
    if (searchForm) {
        const searchInput = searchForm.querySelector('input[name="search"]');
        if (searchInput) {
            let searchTimeout;
            searchInput.addEventListener('input', function() {
                clearTimeout(searchTimeout);
                searchTimeout = setTimeout(() => {
                    // Auto-submit after 1 second of no typing
                    if (this.value.length >= 3 || this.value.length === 0) {
                        searchForm.submit();
                    }
                }, 1000);
            });
        }
    }

    // Smooth animations for page transitions
    const pageLinks = document.querySelectorAll('.pagination .page-link');
    pageLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            if (!this.closest('.page-item').classList.contains('active')) {
                document.body.style.opacity = '0.7';
                setTimeout(() => {
                    document.body.style.opacity = '1';
                }, 300);
            }
        });
    });

    // Enhanced footer social links
    const socialLinks = document.querySelectorAll('.social-link');
    socialLinks.forEach(link => {
        link.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px) scale(1.1)';
        });
        
        link.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0) scale(1)';
        });
    });

    // Certificate modal preview (if needed in future)
    const certificateImages = document.querySelectorAll('.certificate-img, .certificate-img-home');
    certificateImages.forEach(img => {
        img.addEventListener('click', function() {
            // Future: Open modal with larger image
            console.log('Certificate image clicked:', this.alt);
        });
    });

    // Scroll to top functionality
    const scrollToTopBtn = document.createElement('button');
    scrollToTopBtn.innerHTML = '<i class="bi bi-arrow-up"></i>';
    scrollToTopBtn.className = 'btn btn-primary position-fixed';
    scrollToTopBtn.style.cssText = `
        bottom: 20px;
        right: 20px;
        z-index: 1000;
        border-radius: 50%;
        width: 50px;
        height: 50px;
        display: none;
        box-shadow: 0 4px 15px rgba(0,0,0,0.2);
    `;
    
    document.body.appendChild(scrollToTopBtn);

    window.addEventListener('scroll', function() {
        if (window.pageYOffset > 300) {
            scrollToTopBtn.style.display = 'block';
        } else {
            scrollToTopBtn.style.display = 'none';
        }
    });

    scrollToTopBtn.addEventListener('click', function() {
        window.scrollTo({
            top: 0,
            behavior: 'smooth'
        });
    });
});

// Utility functions
function showToast(message, type = 'info') {
    const toast = document.createElement('div');
    toast.className = `alert alert-${type} position-fixed`;
    toast.style.cssText = `
        top: 20px;
        right: 20px;
        z-index: 9999;
        min-width: 300px;
        animation: slideIn 0.3s ease;
    `;
    toast.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(toast);
    
    setTimeout(() => {
        toast.remove();
    }, 5000);
}

// Add CSS for animations
const style = document.createElement('style');
style.textContent = `
    @keyframes slideIn {
        from {
            transform: translateX(100%);
            opacity: 0;
        }
        to {
            transform: translateX(0);
            opacity: 1;
        }
    }
    
    .certificate-card, .certificate-card-home {
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }
    
    .pagination .page-link {
        transition: all 0.2s ease;
    }
    
    .social-link {
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }
`;
document.head.appendChild(style);
// Enhanced navbar functionality
document.addEventListener('DOMContentLoaded', function() {
    // Navbar dropdown hover effects
    const dropdownToggles = document.querySelectorAll('.navbar-nav .dropdown-toggle');
    
    dropdownToggles.forEach(toggle => {
        const dropdown = toggle.nextElementSibling;
        let hoverTimeout;
        
        // Show dropdown on hover (desktop only)
        if (window.innerWidth > 991) {
            toggle.addEventListener('mouseenter', function() {
                clearTimeout(hoverTimeout);
                const bsDropdown = new bootstrap.Dropdown(this);
                bsDropdown.show();
            });
            
            toggle.parentElement.addEventListener('mouseleave', function() {
                hoverTimeout = setTimeout(() => {
                    const bsDropdown = bootstrap.Dropdown.getInstance(toggle);
                    if (bsDropdown) {
                        bsDropdown.hide();
                    }
                }, 300);
            });
        }
    });
    
    // Active menu highlighting
    function updateActiveMenu() {
        const currentPath = window.location.pathname;
        const navLinks = document.querySelectorAll('.navbar-nav .nav-link, .dropdown-item');
        
        navLinks.forEach(link => {
            link.classList.remove('active');
            const href = link.getAttribute('href');
            
            if (href && currentPath.includes(href.replace(window.location.origin, ''))) {
                link.classList.add('active');
                
                // If it's a dropdown item, also activate the parent
                const parentDropdown = link.closest('.dropdown');
                if (parentDropdown) {
                    const parentToggle = parentDropdown.querySelector('.dropdown-toggle');
                    if (parentToggle) {
                        parentToggle.classList.add('active');
                    }
                }
            }
        });
    }
    
    updateActiveMenu();
    
    // Smooth navbar collapse on mobile
    const navbarToggler = document.querySelector('.navbar-toggler');
    const navbarCollapse = document.querySelector('.navbar-collapse');
    
    if (navbarToggler && navbarCollapse) {
        // Close navbar when clicking outside
        document.addEventListener('click', function(e) {
            if (!navbarCollapse.contains(e.target) && !navbarToggler.contains(e.target)) {
                const bsCollapse = bootstrap.Collapse.getInstance(navbarCollapse);
                if (bsCollapse && navbarCollapse.classList.contains('show')) {
                    bsCollapse.hide();
                }
            }
        });
        
        // Close navbar when clicking on nav links (mobile)
        const navLinks = document.querySelectorAll('.navbar-nav .nav-link:not(.dropdown-toggle)');
        navLinks.forEach(link => {
            link.addEventListener('click', function() {
                if (window.innerWidth <= 991) {
                    const bsCollapse = bootstrap.Collapse.getInstance(navbarCollapse);
                    if (bsCollapse && navbarCollapse.classList.contains('show')) {
                        bsCollapse.hide();
                    }
                }
            });
        });
    }
    
    // Navbar scroll effect
    let lastScrollTop = 0;
    const navbar = document.querySelector('.navbar');
    
    window.addEventListener('scroll', function() {
        const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
        
        if (scrollTop > lastScrollTop && scrollTop > 100) {
            // Scrolling down
            navbar.style.transform = 'translateY(-100%)';
        } else {
            // Scrolling up
            navbar.style.transform = 'translateY(0)';
        }
        
        // Add background when scrolled
        if (scrollTop > 50) {
            navbar.classList.add('navbar-scrolled');
        } else {
            navbar.classList.remove('navbar-scrolled');
        }
        
        lastScrollTop = scrollTop;
    });
});

// Education form enhancements
function initializeEducationForm() {
    const statusSelect = document.getElementById('status_pendidikan');
    const tahunSelesaiContainer = document.getElementById('tahun_selesai_container');
    const tahunSelesaiInput = document.getElementById('tahun_selesai');
    
    if (statusSelect && tahunSelesaiContainer && tahunSelesaiInput) {
        statusSelect.addEventListener('change', function() {
            const status = this.value;
            
            if (status === 'sedang_menempuh') {
                tahunSelesaiContainer.style.opacity = '0.5';
                tahunSelesaiInput.disabled = true;
                tahunSelesaiInput.value = '';
                tahunSelesaiInput.placeholder = 'Tidak diperlukan (sedang menempuh)';
                
                // Add visual indicator
                const indicator = document.createElement('div');
                indicator.className = 'alert alert-info alert-sm mt-2';
                indicator.innerHTML = '<i class="bi bi-info-circle me-1"></i>Status sedang menempuh - tahun selesai tidak diperlukan';
                indicator.id = 'status-indicator';
                
                // Remove existing indicator
                const existingIndicator = document.getElementById('status-indicator');
                if (existingIndicator) {
                    existingIndicator.remove();
                }
                
                tahunSelesaiContainer.appendChild(indicator);
            } else {
                tahunSelesaiContainer.style.opacity = '1';
                tahunSelesaiInput.disabled = false;
                tahunSelesaiInput.placeholder = 'Contoh: 2019';
                
                // Remove indicator
                const indicator = document.getElementById('status-indicator');
                if (indicator) {
                    indicator.remove();
                }
            }
        });
        
        // Initialize on page load
        statusSelect.dispatchEvent(new Event('change'));
    }
}

// Initialize education form if on admin page
if (window.location.pathname.includes('/admin/education/')) {
    document.addEventListener('DOMContentLoaded', initializeEducationForm);
}